<?php
// Funzione per ottenere l'IP originale del client
function getClientIP() {
    // Se la richiesta proviene da un proxy o CDN, usa l'intestazione X-Forwarded-For
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // L'intestazione può contenere una lista di IP separati da virgola, quindi prendi il primo
        $ip_list = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ip_list[0]); // Prendi il primo IP nella lista
    } else {
        // Se non esiste X-Forwarded-For, restituisci l'IP diretto del client
        return $_SERVER['REMOTE_ADDR'];
    }
}

// Verifica l'IP del client che sta facendo la richiesta
$client_ip = getClientIP();

// Funzione per ottenere i dati dettagliati di un clan
function getClanInfo($clan_id, $application_id) {
    $url = "https://api.worldoftanks.eu/wot/clans/info/?application_id=$application_id&clan_id=$clan_id";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    
    curl_close($ch);
    
    return json_decode($response, true);
}

// Chiave API
$application_id = 'API_ID_KEYS'; // La tua chiave API
$clan_id_1 = 'CLAN_ID';  // ID del clan

// Ottieni le informazioni del clan
$clan_info_1 = getClanInfo($clan_id_1, $application_id);
?>

<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Numărul de Membri ai Clanului</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>GWAP</h1>

        <!-- Afișează numărul de membri -->
        <?php if (isset($clan_info_1['data'][$clan_id_1])): ?>
            <p>Numărul de Membri: <?php echo $clan_info_1['data'][$clan_id_1]['members_count']; ?></p>
        <?php else: ?>
            <p>Clanul nu a fost găsit.</p>
        <?php endif; ?>
    </div>
</body>
</html>
